/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.tableUtils;

import com.quantumdata.sam.tableUtils.ICellAttribute;
import com.quantumdata.sam.tableUtils.ICellBorder;
import com.quantumdata.sam.tableUtils.ICellColor;
import com.quantumdata.sam.tableUtils.ICellFont;
import com.quantumdata.sam.tableUtils.ICellSpan;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.border.Border;

public class DefaultCellAttribute
implements ICellAttribute,
ICellSpan,
ICellColor,
ICellFont,
ICellBorder {
    protected int rowSize;
    protected int columnSize;
    protected int[][][] span;
    protected Color[][] foreground;
    protected Color[][] background;
    protected Font[][] font;
    protected Border[][] border;

    public DefaultCellAttribute(int n, int n2) {
        this.rowSize = n;
        this.columnSize = n2;
        this.span = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.border = null;
        if (this.rowSize > 0 && this.columnSize > 0) {
            this.span = new int[this.rowSize][this.columnSize][2];
            this.foreground = new Color[this.rowSize][this.columnSize];
            this.background = new Color[this.rowSize][this.columnSize];
            this.font = new Font[this.rowSize][this.columnSize];
            this.border = new Border[this.rowSize][this.columnSize];
            this.Initialize();
        }
    }

    protected void Initialize() {
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                this.span[i][j][0] = 1;
                this.span[i][j][1] = 1;
            }
        }
    }

    public void deleteRow() {
        --this.rowSize;
        if (this.rowSize == 0) {
            this.span = null;
            this.foreground = null;
            this.background = null;
            this.font = null;
            this.border = null;
        } else {
            this.span = new int[this.rowSize][this.columnSize][2];
            this.foreground = new Color[this.rowSize][this.columnSize];
            this.background = new Color[this.rowSize][this.columnSize];
            this.font = new Font[this.rowSize][this.columnSize];
            this.border = new Border[this.rowSize][this.columnSize];
            this.Initialize();
        }
    }

    public void insertRow() {
        ++this.rowSize;
        this.span = new int[this.rowSize][this.columnSize][2];
        this.foreground = new Color[this.rowSize][this.columnSize];
        this.background = new Color[this.rowSize][this.columnSize];
        this.font = new Font[this.rowSize][this.columnSize];
        this.border = new Border[this.rowSize][this.columnSize];
        this.Initialize();
    }

    public int[] getSpan(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            int[] nArray = new int[]{1, 1};
            return nArray;
        }
        return this.span[n][n2];
    }

    public void setSpan(int[] nArray, int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        this.span[n][n2] = nArray;
    }

    public boolean isVisible(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return false;
        }
        return this.span[n][n2][1] >= 1 && this.span[n][n2][0] >= 1;
    }

    public void combine(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = new int[]{n3};
        this.combine(nArray, nArray2);
    }

    public void combine(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (this.isOutOfBounds(nArray, nArray2)) {
            return;
        }
        int n3 = nArray.length;
        int n4 = nArray2.length;
        int n5 = nArray[0];
        int n6 = nArray2[0];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (this.span[n5 + n2][n6 + n][1] == 1 && this.span[n5 + n2][n6 + n][0] == 1) continue;
                return;
            }
        }
        n2 = 0;
        n = 0;
        while (n2 < n3) {
            int n7 = 0;
            for (int i = 0; i < n4; ++i) {
                this.span[n5 + n2][n6 + i][1] = n7--;
                this.span[n5 + n2][n6 + i][0] = n;
            }
            ++n2;
            --n;
        }
        this.span[n5][n6][1] = n4;
        this.span[n5][n6][0] = n3;
    }

    public void split(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        int n3 = this.span[n][n2][1];
        int n4 = this.span[n][n2][0];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.span[n + i][n2 + j][1] = 1;
                this.span[n + i][n2 + j][0] = 1;
            }
        }
    }

    public Color getForeground(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return null;
        }
        return this.foreground[n][n2];
    }

    public void setForeground(Color color, int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        this.foreground[n][n2] = color;
    }

    public Color getBackground(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return null;
        }
        return this.background[n][n2];
    }

    public void setBackground(Color color, int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        this.background[n][n2] = color;
    }

    public Font getFont(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return null;
        }
        return this.font[n][n2];
    }

    public void setFont(Font font, int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        this.font[n][n2] = font;
    }

    public void deleteColumn(int n) {
        --this.columnSize;
        if (this.columnSize == 0) {
            this.span = null;
            this.foreground = null;
            this.background = null;
            this.font = null;
            this.border = null;
        } else {
            this.span = new int[this.rowSize][this.columnSize][2];
            this.foreground = new Color[this.rowSize][this.columnSize];
            this.background = new Color[this.rowSize][this.columnSize];
            this.font = new Font[this.rowSize][this.columnSize];
            this.border = new Border[this.rowSize][this.columnSize];
            this.Initialize();
        }
    }

    public void insertColumn(int n) {
        ++this.columnSize;
        this.span = new int[this.rowSize][this.columnSize][2];
        this.foreground = new Color[this.rowSize][this.columnSize];
        this.background = new Color[this.rowSize][this.columnSize];
        this.font = new Font[this.rowSize][this.columnSize];
        this.border = new Border[this.rowSize][this.columnSize];
        this.Initialize();
    }

    public Dimension getSize() {
        return new Dimension(this.rowSize, this.columnSize);
    }

    protected boolean isOutOfBounds(int n, int n2) {
        return n < 0 || this.rowSize <= n || n2 < 0 || this.columnSize <= n2;
    }

    protected boolean isOutOfBounds(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0 && this.rowSize > nArray[n]) continue;
            return true;
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] >= 0 && this.columnSize > nArray2[n]) continue;
            return true;
        }
        return false;
    }

    public Border getBorder(int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return null;
        }
        return this.border[n][n2];
    }

    public void setBorder(Border border, int n, int n2) {
        if (this.isOutOfBounds(n, n2)) {
            return;
        }
        this.border[n][n2] = border;
    }
}

